﻿;Copyright 2004-2010 John T. Haller

;Website: http://PortableApps.com/ThunderbirdPortable

;This software is OSI Certified Open Source Software.
;OSI Certified is a certification mark of the Open Source Initiative.

;This program is free software; you can redistribute it and/or
;modify it under the terms of the GNU General Public License
;as published by the Free Software Foundation; either version 2
;of the License, or (at your option) any later version.

;This program is distributed in the hope that it will be useful,
;but WITHOUT ANY WARRANTY; without even the implied warranty of
;MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
;GNU General Public License for more details.

;You should have received a copy of the GNU General Public License
;along with this program; if not, write to the Free Software
;Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.

!define PORTABLEAPPNAME "Mozilla Thunderbird, Portable Edition"
!define APPNAME "Thunderbird"
!define NAME "ThunderbirdPortable"
!define VER "1.6.11.0"
!define WEBSITE "PortableApps.com/ThunderbirdPortable"
!define DEFAULTEXE "thunderbird.exe"
!define DEFAULTAPPDIR "thunderbird"
!define DEFAULTGPGPATH "gpg"
!define DEFAULTGPGHOME "gpg"
!define LAUNCHERLANGUAGE "English"

;=== Program Details
Name "${PORTABLEAPPNAME}"
OutFile "..\..\${NAME}.exe"
Caption "${PORTABLEAPPNAME} | PortableApps.com"
VIProductVersion "${VER}"
VIAddVersionKey ProductName "${PORTABLEAPPNAME}"
VIAddVersionKey Comments "Allows ${APPNAME} to be run from a removable drive.  For additional details, visit ${WEBSITE}"
VIAddVersionKey CompanyName "PortableApps.com"
VIAddVersionKey LegalCopyright "John T. Haller"
VIAddVersionKey FileDescription "${PORTABLEAPPNAME}"
VIAddVersionKey FileVersion "${VER}"
VIAddVersionKey ProductVersion "${VER}"
VIAddVersionKey InternalName "${PORTABLEAPPNAME}"
VIAddVersionKey LegalTrademarks "Thunderbird is a Trademark of The Mozilla Foundation.  PortableApps.com is a Trademark of Rare Ideas, LLC."
VIAddVersionKey OriginalFilename "${NAME}.exe"
;VIAddVersionKey PrivateBuild ""
;VIAddVersionKey SpecialBuild ""

;=== Runtime Switches
CRCCheck On
WindowIcon Off
SilentInstall Silent
AutoCloseWindow True
RequestExecutionLevel user
XPStyle On

; Best Compression
SetCompress Auto
SetCompressor /SOLID lzma
SetCompressorDictSize 32
SetDatablockOptimize On


;=== Include
;(Standard NSIS)
!include Registry.nsh
!include TextFunc.nsh
!insertmacro GetParent
!insertmacro GetParameters
!include WordFunc.nsh
!insertmacro WordReplace

;(NSIS Plugins)
!include TextReplace.nsh

;(Custom)
!include CheckForPlatformSplashDisable.nsh
!include ReplaceInFileWithTextReplace.nsh
!include ReadINIStrWithDefault.nsh
!include SetFileAttributesDirectoryNormal.nsh


;=== Program Icon
Icon "..\..\App\AppInfo\appicon.ico"

;=== Languages
LoadLanguageFile "${NSISDIR}\Contrib\Language files\${LAUNCHERLANGUAGE}.nlf"
!include PortableApps.comLauncherLANG_${LAUNCHERLANGUAGE}.nsh

;=== Variables
Var PROGRAMDIRECTORY
Var PROFILEDIRECTORY
Var ORIGINALPROFILEDIRECTORY
Var SETTINGSDIRECTORY
Var PLUGINSDIRECTORY
Var GPGPATHDIRECTORY
Var GPGHOMEDIRECTORY
Var ADDITIONALPARAMETERS
Var ALLOWMULTIPLEINSTANCES
Var SKIPCOMPREGFIX
Var EXECSTRING
Var PROGRAMEXECUTABLE
Var DISABLESPLASHSCREEN
Var DISABLEINTELLIGENTSTART
Var ISDEFAULTDIRECTORY
Var RUNLOCALLY
Var WAITFORPROGRAM
Var LASTPROFILEDIRECTORY
Var SECONDARYLAUNCH
Var USERTYPE
Var MISSINGFILEORPATH
Var NOUNREADMAILKEY


Section "Main"
	;=== Find the INI file, if there is one
	IfFileExists "$EXEDIR\${NAME}.ini" "" NoINI

		;=== Read the parameters from the INI file
		${ReadINIStrWithDefault} $0 "$EXEDIR\${NAME}.ini" "${NAME}" "${APPNAME}Directory" "App\${DEFAULTAPPDIR}"
		StrCpy $PROGRAMDIRECTORY "$EXEDIR\$0"
		${ReadINIStrWithDefault} $0 "$EXEDIR\${NAME}.ini" "${NAME}" "ProfileDirectory" "Data\profile"
		StrCpy $PROFILEDIRECTORY "$EXEDIR\$0"
		${ReadINIStrWithDefault} $0 "$EXEDIR\${NAME}.ini" "${NAME}" "SettingsDirectory" "Data\settings"
		StrCpy $SETTINGSDIRECTORY "$EXEDIR\$0"
		${ReadINIStrWithDefault} $0 "$EXEDIR\${NAME}.ini" "${NAME}" "GPGPathDirectory" "App\${DEFAULTGPGPATH}"
		StrCpy $GPGPATHDIRECTORY "$EXEDIR\$0"
		${ReadINIStrWithDefault} $0 "$EXEDIR\${NAME}.ini" "${NAME}" "GPGHomeDirectory" "Data\${DEFAULTGPGHOME}"
		StrCpy $GPGHOMEDIRECTORY "$EXEDIR\$0"
		${ReadINIStrWithDefault} $0 "$EXEDIR\${NAME}.ini" "${NAME}" "PluginsDirectory" "Data\plugins"
		StrCpy $PLUGINSDIRECTORY "$EXEDIR\$0"
		${ReadINIStrWithDefault} $ADDITIONALPARAMETERS "$EXEDIR\${NAME}.ini" "${NAME}" "AdditionalParameters" ""
		${ReadINIStrWithDefault} $ALLOWMULTIPLEINSTANCES "$EXEDIR\${NAME}.ini" "${NAME}" "AllowMultipleInstances" "false"
		${ReadINIStrWithDefault} $SKIPCOMPREGFIX "$EXEDIR\${NAME}.ini" "${NAME}" "SkipCompregFix" "false"
		${ReadINIStrWithDefault} $PROGRAMEXECUTABLE "$EXEDIR\${NAME}.ini" "${NAME}" "${APPNAME}Executable" "${DEFAULTEXE}"
		${ReadINIStrWithDefault} $WAITFORPROGRAM "$EXEDIR\${NAME}.ini" "${NAME}" "WaitFor${APPNAME}" "false"
		${ReadINIStrWithDefault} $DISABLESPLASHSCREEN "$EXEDIR\${NAME}.ini" "${NAME}" "DisableSplashScreen" "false"
		${ReadINIStrWithDefault} $DISABLEINTELLIGENTSTART "$EXEDIR\${NAME}.ini" "${NAME}" "DisableIntelligentStart" "false"
		${ReadINIStrWithDefault} $RUNLOCALLY "$EXEDIR\${NAME}.ini" "${NAME}" "RunLocally" "false"
		StrCmp $RUNLOCALLY "true" "" CheckForDefault
			StrCpy $WAITFORPROGRAM "true"
		
		CheckForDefault:
			;=== Check if default directories
			StrCmp $PROGRAMDIRECTORY "$EXEDIR\App\${DEFAULTAPPDIR}" "" EndINI
			StrCmp $PROFILEDIRECTORY "$EXEDIR\Data\profile" "" EndINI
			StrCmp $PLUGINSDIRECTORY "$EXEDIR\Data\plugins" "" EndINI
			StrCmp $SETTINGSDIRECTORY "$EXEDIR\Data\settings" "" EndINI
			StrCmp $GPGPATHDIRECTORY "$EXEDIR\App\${DEFAULTGPGPATH}" "" EndINI
			StrCmp $GPGHOMEDIRECTORY "$EXEDIR\Data\${DEFAULTGPGHOME}" "" EndINI
			StrCpy $ISDEFAULTDIRECTORY "true"
	
		EndINI:
			IfFileExists "$PROGRAMDIRECTORY\$PROGRAMEXECUTABLE" FoundProgramEXE NoProgramEXE

	NoINI:
		;=== No INI file, so we'll use the defaults
		StrCpy $ADDITIONALPARAMETERS ""
		StrCpy $ALLOWMULTIPLEINSTANCES "false"
		StrCpy $SKIPCOMPREGFIX "false"
		StrCpy $WAITFORPROGRAM "false"
		StrCpy $PROGRAMEXECUTABLE "${DEFAULTEXE}"
		StrCpy $DISABLESPLASHSCREEN "false"
		StrCpy $DISABLEINTELLIGENTSTART "false"

		IfFileExists "$EXEDIR\App\${DEFAULTAPPDIR}\${DEFAULTEXE}" "" NoProgramEXE
			StrCpy $PROGRAMDIRECTORY "$EXEDIR\App\${DEFAULTAPPDIR}"
			StrCpy $PROFILEDIRECTORY "$EXEDIR\Data\profile"
			StrCpy $PLUGINSDIRECTORY "$EXEDIR\Data\plugins"
			StrCpy $SETTINGSDIRECTORY "$EXEDIR\Data\settings"
			StrCpy $GPGPATHDIRECTORY "$EXEDIR\App\${DEFAULTGPGPATH}"
			StrCpy $GPGHOMEDIRECTORY "$EXEDIR\Data\${DEFAULTGPGHOME}"
			StrCpy $ISDEFAULTDIRECTORY "true"
			Goto FoundProgramEXE

	NoProgramEXE:
		;=== Program executable not where expected
		StrCpy $MISSINGFILEORPATH $PROGRAMEXECUTABLE
		MessageBox MB_OK|MB_ICONEXCLAMATION `$(LauncherFileNotFound)`
		Abort
		
	FoundProgramEXE:
		StrCpy $ORIGINALPROFILEDIRECTORY $PROFILEDIRECTORY
		;=== Check if running
		StrCmp $ALLOWMULTIPLEINSTANCES "true" ProfileWork
		FindProcDLL::FindProc "thunderbird.exe"
		StrCmp $R0 "1" "" ProfileWork
			;=== Already running, check if it is using the portable profile
			IfFileExists "$PROFILEDIRECTORY\parent.lock" "" WarnAnotherInstance
				StrCpy $SECONDARYLAUNCH "true"
				Goto RunProgram
		
	WarnAnotherInstance:
		MessageBox MB_OK|MB_ICONINFORMATION `$(LauncherAlreadyRunning)`
		Abort
	
	ProfileWork:
	;=== Check for an existing profile
	IfFileExists "$PROFILEDIRECTORY\prefs.js" ProfileFound
		;=== No profile was found
		StrCmp $ISDEFAULTDIRECTORY "true" CopyDefaultProfile CreateProfile
	
	CopyDefaultProfile:
		CreateDirectory "$EXEDIR\Data"
		CreateDirectory "$EXEDIR\Data\plugins"
		CreateDirectory "$EXEDIR\Data\profile"
		CreateDirectory "$EXEDIR\Data\gpg"
		CopyFiles /SILENT $EXEDIR\App\DefaultData\plugins\*.* $EXEDIR\Data\plugins
		CopyFiles /SILENT $EXEDIR\App\DefaultData\profile\*.* $EXEDIR\Data\profile
		CopyFiles /SILENT $EXEDIR\App\DefaultData\gpg\*.* $EXEDIR\Data\gpg
		IfFileExists "$EXEDIR\Data\settings\ThunderbirdPortableSettings.ini" ProfileFound
			CreateDirectory "$EXEDIR\Data\settings"
			CopyFiles /SILENT $EXEDIR\App\DefaultData\settings\*.* $EXEDIR\Data\settings
		GoTo ProfileFound
	
	CreateProfile:
		IfFileExists "$PROFILEDIRECTORY\*.*" ProfileFound
		CreateDirectory "$PROFILEDIRECTORY"

	ProfileFound:
		IfFileExists "$SETTINGSDIRECTORY\ThunderbirdPortableSettings.ini" SettingsFound
			CreateDirectory "$SETTINGSDIRECTORY"
			FileOpen $R0 "$SETTINGSDIRECTORY\ThunderbirdPortableSettings.ini" w
			FileClose $R0
			WriteINIStr "$SETTINGSDIRECTORY\ThunderbirdPortableSettings.ini" "ThunderbirdPortableSettings" "LastProfileDirectory" "NONE"
			
	SettingsFound:
		;=== Check for read/write
		StrCmp $RUNLOCALLY "true" DisplaySplash
		ClearErrors
		FileOpen $R0 "$PROFILEDIRECTORY\writetest.temp" w
		IfErrors "" WriteSuccessful
			;== Write failed, so we're read-only
			MessageBox MB_YESNO|MB_ICONQUESTION `$(LauncherAskCopyLocal)` IDYES SwitchToRunLocally
			MessageBox MB_OK|MB_ICONINFORMATION `$(LauncherNoReadOnly)`
			Abort
			
	SwitchToRunLocally:
		StrCpy $RUNLOCALLY "true"
		StrCpy $WAITFORPROGRAM "true"
		Goto DisplaySplash
	
	WriteSuccessful:
		FileClose $R0
		Delete "$PROFILEDIRECTORY\writetest.temp"
	
	DisplaySplash:
		${CheckForPlatformSplashDisable} $DISABLESPLASHSCREEN
		StrCmp $DISABLESPLASHSCREEN "true" SkipSplashScreen
			;=== Show the splash screen before processing the files
			InitPluginsDir
			File /oname=$PLUGINSDIR\splash.jpg "${NAME}.jpg"
			newadvsplash::show /NOUNLOAD 2000 0 0 -1 /L $PLUGINSDIR\splash.jpg

	SkipSplashScreen:
		;=== Run locally if needed (aka Portable Thunderbird Live)
		StrCmp $RUNLOCALLY "true" "" CompareProfilePath
			RMDir /r "$TEMP\${NAME}\"
			CreateDirectory $TEMP\${NAME}\profile
			CreateDirectory $TEMP\${NAME}\plugins
			CreateDirectory $TEMP\${NAME}\program
			CreateDirectory $TEMP\${NAME}\gpghome
			CreateDirectory $TEMP\${NAME}\gpgpath
			CreateDirectory $TEMP\${NAME}\registry
			CopyFiles /SILENT $PROFILEDIRECTORY\*.* $TEMP\${NAME}\profile
			StrCpy $PROFILEDIRECTORY $TEMP\${NAME}\profile
			CopyFiles /SILENT $PLUGINSDIRECTORY\*.* $TEMP\${NAME}\plugins
			StrCpy $PROFILEDIRECTORY $TEMP\${NAME}\plugins
			CopyFiles /SILENT $PROGRAMDIRECTORY\*.* $TEMP\${NAME}\program
			StrCpy $PROGRAMDIRECTORY $TEMP\${NAME}\program
			CopyFiles /SILENT $GPGPATHDIRECTORY\*.* $TEMP\${NAME}\gpgpath
			StrCpy $GPGPATHDIRECTORY $TEMP\${NAME}\gpgpath
			CopyFiles /SILENT $GPGHOMEDIRECTORY\*.* $TEMP\${NAME}\gpghome
			StrCpy $GPGHOMEDIRECTORY $TEMP\${NAME}\gpghome
			${SetFileAttributesDirectoryNormal} "$TEMP\${NAME}"

	CompareProfilePath:
		ReadINIStr $LASTPROFILEDIRECTORY "$SETTINGSDIRECTORY\${NAME}Settings.ini" "${NAME}Settings" "LastProfileDirectory"
		StrCmp $PROFILEDIRECTORY $LASTPROFILEDIRECTORY "" RememberProfilePath
			StrCmp $DISABLEINTELLIGENTSTART "true" RememberProfilePath
				StrCpy $SKIPCOMPREGFIX "true"

	RememberProfilePath:
		WriteINIStr "$SETTINGSDIRECTORY\${NAME}Settings.ini" "${NAME}Settings" "LastProfileDirectory" "$PROFILEDIRECTORY"
	
	;FixPrefsJs:
		IfFileExists "$PROFILEDIRECTORY\prefs.js" "" FixMimeTypes
		StrCmp $LASTPROFILEDIRECTORY "NONE" FixPrefsJsPart2
		StrCpy $2 $LASTPROFILEDIRECTORY 1 ;Last drive letter
		StrCpy $3 $PROFILEDIRECTORY 1 ;Current drive letter
		StrCmp $2 $3 FixPrefsJsPart2 ;If no change, move on
				
		;=== Replace drive letter entries
		${ReplaceInFileCS} "$PROFILEDIRECTORY\prefs.js" `file:///$2` `file:///$3`
		${ReplaceInFile} "$PROFILEDIRECTORY\prefs.js" `", "$2:\\` `", "$3:\\`
	
	FixPrefsJsPart2:
		;=== Be sure the default browser check is disabled
		FileOpen $0 "$PROFILEDIRECTORY\prefs.js" a
		FileSeek $0 0 END
		FileWriteByte $0 "13"
		FileWriteByte $0 "10"
		FileWrite $0 `user_pref("mail.shell.checkDefaultClient", false);`
		FileWriteByte $0 "13"
		FileWriteByte $0 "10"
		FileWrite $0 `user_pref("mail.winsearch.firstRunDone", true);`
		FileWriteByte $0 "13"
		FileWriteByte $0 "10"
		FileWrite $0 `user_pref("mail.winsearch.enable", false);`
		FileWriteByte $0 "13"
		FileWriteByte $0 "10"
		
	;FixPrefsJsClose:
		FileClose $0 

		
	FixMimeTypes:
		IfFileExists "$PROFILEDIRECTORY\mimeTypes.rdf" "" RunProgram
		StrCmp $LASTPROFILEDIRECTORY "NONE" RunProgram
		${GetParent} $LASTPROFILEDIRECTORY $0
		${GetParent} $0 $0
		${GetParent} $0 $0
		Pop $0 ;Last PortableApps Directory
		StrCpy $0 '$0\'
		${GetParent} $ORIGINALPROFILEDIRECTORY $1
		${GetParent} $1 $1
		${GetParent} $1 $1
		Pop $1 ;Current PortableApps Directory
		StrCpy $1 '$1\'
		StrCmp $0 $1 RunProgram
		${ReplaceInFile} "$PROFILEDIRECTORY\mimeTypes.rdf" $0 $1
	
	RunProgram:
		StrCmp $SKIPCOMPREGFIX "true" GetPassedParameters

		;=== Delete component registry to ensure compatibility with all extensions
		Delete $PROFILEDIRECTORY\compreg.dat

	GetPassedParameters:
		;=== Get any passed parameters
		${GetParameters} $0
		StrCmp "'$0'" "''" "" LaunchProgramParameters

		;=== No parameters
		StrCpy $EXECSTRING `"$PROGRAMDIRECTORY\$PROGRAMEXECUTABLE" -profile "$PROFILEDIRECTORY"`
		Goto CheckMultipleInstances

	LaunchProgramParameters:
		StrCpy $EXECSTRING `"$PROGRAMDIRECTORY\$PROGRAMEXECUTABLE" -profile "$PROFILEDIRECTORY" $0`

	CheckMultipleInstances:
		StrCmp $ALLOWMULTIPLEINSTANCES "true" "" AdditionalParameters
		StrCpy $EXECSTRING `$EXECSTRING -no-remote`

	AdditionalParameters:
		StrCmp $ADDITIONALPARAMETERS "" PluginsEnvironment

		;=== Additional Parameters
		StrCpy $EXECSTRING `$EXECSTRING $ADDITIONALPARAMETERS`

	PluginsEnvironment:
		;=== Set the plugins directory if we have a path
		StrCmp $PLUGINSDIRECTORY "" GPGEnvironment
		IfFileExists "$PLUGINSDIRECTORY\*.*" "" GPGEnvironment
		System::Call 'Kernel32::SetEnvironmentVariable(t, t) i("MOZ_PLUGIN_PATH", "$PLUGINSDIRECTORY").r0'
		
	GPGEnvironment:
		;=== Set the GPG Environment if the files are present
		IfFileExists "$GPGPATHDIRECTORY\gpg.exe" "" LaunchNow

		;=== Setup the Path so that gpg.exe can be found by Enigmail
		ReadEnvStr $R0 "PATH"
		StrCpy $R0 "$GPGPATHDIRECTORY;$R0"
		System::Call 'Kernel32::SetEnvironmentVariable(t, t) i("PATH", "$R0").r0'

		;=== Setup GNUPGHOME so that we don't have to use the registry
		StrCpy $R0 "$GPGHOMEDIRECTORY"
		System::Call 'Kernel32::SetEnvironmentVariable(t, t) i("GNUPGHOME", "$R0").r0'
		
		IfFileExists "$PROFILEDIRECTORY\prefs.js" "" LaunchNow
			FileOpen $0 "$PROFILEDIRECTORY\prefs.js" a
			FileSeek $0 0 END
			FileWriteByte $0 "13"
			FileWriteByte $0 "10"
			${WordReplace} "$GPGPATHDIRECTORY\gpg.exe" "\" "\\" "+" $1
			FileWrite $0 `user_pref("extensions.enigmail.agentPath", "$1");`
			FileWriteByte $0 "13"
			FileWriteByte $0 "10"
			FileClose $0

	LaunchNow:
		StrCmp $ALLOWMULTIPLEINSTANCES "true" StartProgramNow
		StrCmp $SECONDARYLAUNCH "true" StartProgramAndExit
		;=== Check for registry permissions
		UserInfo::GetAccountType
		Pop $0
		StrCpy $USERTYPE $0
		StrCmp $USERTYPE "Guest" StartProgramNow
		${registry::KeyExists} "HKEY_CURRENT_USER\Software\Microsoft\Windows\CurrentVersion\UnreadMail" $R0
		StrCmp $R0 "-1" +3 ;=== If it doesn't exist, skip the next line
			${registry::CopyKey} "HKEY_CURRENT_USER\Software\Microsoft\Windows\CurrentVersion\UnreadMail" "HKEY_CURRENT_USER\Software\Microsoft\Windows\CurrentVersion\UnreadMail-BackupByThunderbirdPortable" $R0
		Goto +2
			StrCpy $NOUNREADMAILKEY "true"
		StrCmp $USERTYPE "User" StartProgramNow
		${registry::KeyExists} "HKEY_LOCAL_MACHINE\SOFTWARE\Mozilla Thunderbird" $R0
		StrCmp $R0 "-1" +3 ;=== If it doesn't exist, skip the next 2 lines
		${registry::MoveKey} "HKEY_LOCAL_MACHINE\SOFTWARE\Mozilla Thunderbird" "HKEY_LOCAL_MACHINE\SOFTWARE\Mozilla Thunderbird-BackupByThunderbirdPortable" $R0
		Sleep 100
		${registry::Write} "HKEY_LOCAL_MACHINE\SOFTWARE\Mozilla Thunderbird\Desktop" "showMapiDialog" "0" "REG_SZ" $R0
		Sleep 100

	StartProgramNow:
		Rename "$APPDATA\Thunderbird\Crash Reports" "$APPDATA\Thunderbird\Crash Reports-BackupByThunderbirdPortable"
		ExecWait $EXECSTRING
		StrCmp $ALLOWMULTIPLEINSTANCES "true" TheEnd
		
	CheckRunning:
		Sleep 2000
		FindProcDLL::FindProc "thunderbird.exe"
		Pop $R0                     
		StrCmp $R0 "1" "" TheEnd
		IfFileExists "$PROFILEDIRECTORY\parent.lock" CheckRunning TheEnd
	
	StartProgramAndExit:
		Exec $EXECSTRING
		Goto TheRealEnd

	TheEnd:
		;=== Restore registry keys
		;StrCmp $USERTYPE "Guest" EndWithoutRegRestore
		;${registry::KeyExists} "HKEY_CURRENT_USER\Software\Microsoft\Windows\CurrentVersion\UnreadMail-BackupByThunderbirdPortable" $R0
		;StrCmp $R0 "-1" +4 ;=== If it doesn't exist, skip the next 3 lines
		${registry::DeleteKey} "HKEY_CURRENT_USER\Software\Microsoft\Windows\CurrentVersion\UnreadMail" $R0
		Sleep 100
		${registry::MoveKey} "HKEY_CURRENT_USER\Software\Microsoft\Windows\CurrentVersion\UnreadMail-BackupByThunderbirdPortable" "HKEY_CURRENT_USER\Software\Microsoft\Windows\CurrentVersion\UnreadMail" $R0
		StrCmp $NOUNREADMAILKEY "true" 0 +2
			${registry::DeleteKey} "HKEY_CURRENT_USER\Software\Microsoft\Windows\CurrentVersion\UnreadMail" $R0
		StrCmp $USERTYPE "User" EndWithoutRegRestore
		${registry::DeleteKey} "HKEY_LOCAL_MACHINE\SOFTWARE\Mozilla Thunderbird" $R0
		${registry::MoveKey} "HKEY_LOCAL_MACHINE\SOFTWARE\Mozilla Thunderbird-BackupByThunderbirdPortable" "HKEY_LOCAL_MACHINE\SOFTWARE\Mozilla Thunderbird" $R0
	
	EndWithoutRegRestore:
		StrCmp $DISABLESPLASHSCREEN "true" CleanupRunLocally
			Sleep 2000
			newadvsplash::stop

	CleanupRunLocally:
		StrCmp $RUNLOCALLY "true" "" TheRealEnd
		RMDir /r "$TEMP\${NAME}\"

	TheRealEnd:
		${registry::Unload}
		newadvsplash::stop /WAIT
		RMDir "$APPDATA\Mozilla\" ;=== Will only delete if empty (no /r switch)
		RMDir /r "$APPDATA\Thunderbird\Crash Reports"
		Rename "$APPDATA\Thunderbird\Crash Reports-BackupByThunderbirdPortable" "$APPDATA\Thunderbird\Crash Reports"
		RMDir "$APPDATA\Thunderbird\Profiles\" ;=== Will only delete if empty (no /r switch)
		RMDir "$APPDATA\Thunderbird\Profile\" ;=== Will only delete if empty (no /r switch)
		RMDir "$APPDATA\Thunderbird\" ;=== Will only delete if empty (no /r switch)
SectionEnd