VERSION 1.0 CLASS
BEGIN
  MultiUse = -1  'True
  Persistable = 0  'NotPersistable
  DataBindingBehavior = 0  'vbNone
  DataSourceBehavior  = 0  'vbNone
  MTSTransactionMode  = 0  'NotAnMTSObject
END
Attribute VB_Name = "Tooltip"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = True
Attribute VB_PredeclaredId = False
Attribute VB_Exposed = False
Attribute VB_Ext_KEY = "SavedWithClassBuilder6" ,"Yes"
Attribute VB_Ext_KEY = "Top_Level" ,"Yes"
'--------------------------------------------------------------------------------------------------
'                           CLASE PARA HACER APARECER TIPTOOL MULTILINEA
'--------------------------------------------------------------------------------------------------
' KIMALDI electronics, S.L.
' Josep Ricart
' 24/11/08
'--------------------------------------------------------------------------------------------------
Option Explicit

Private Declare Sub InitCommonControls Lib "comctl32.dll" ()

''Windows API Functions
Private Declare Function CreateWindowEx Lib "user32" Alias "CreateWindowExA" (ByVal dwExStyle As Long, ByVal lpClassName As String, ByVal lpWindowName As String, ByVal dwStyle As Long, ByVal X As Long, ByVal Y As Long, ByVal nWidth As Long, ByVal nHeight As Long, ByVal hWndParent As Long, ByVal hMenu As Long, ByVal hInstance As Long, lpParam As Any) As Long
Private Declare Function SendMessage Lib "user32" Alias "SendMessageA" (ByVal hwnd As Long, ByVal wMsg As Long, ByVal wParam As Long, lParam As Any) As Long
Private Declare Function DestroyWindow Lib "user32" (ByVal hwnd As Long) As Long
Private Declare Function SetWindowPos Lib "user32" (ByVal hwnd As Long, ByVal hWndInsertAfter As Long, ByVal X As Long, ByVal Y As Long, ByVal cx As Long, ByVal cy As Long, ByVal wFlags As Long) As Long
Private Declare Function GetClientRect Lib "user32" (ByVal hwnd As Long, lpRect As RECT) As Long

''Windows API Constants
Private Const WM_USER = &H400
Private Const CW_USEDEFAULT = &H80000000
Private Const SWP_NOSIZE = &H1
Private Const SWP_NOACTIVATE = &H10
Private Const SWP_NOMOVE = &H2
Private Const HWND_TOPMOST = -1

' Messages used for setting the duration time of tool 'tips.
' Not used here.
Private Const TTDT_AUTOMATIC = 0
Private Const TTDT_AUTOPOP = 2
Private Const TTDT_INITIAL = 3
Private Const TTDT_RESHOW = 1

''Windows API Types
Private Type RECT
        Left As Long
        Top As Long
        Right As Long
        Bottom As Long
End Type

''Tooltip Window Constants
Private Const TTS_NOPREFIX = &H2
Private Const TTF_TRANSPARENT = &H100
Private Const TTF_CENTERTIP = &H2
Private Const TTM_ADDTOOLA = (WM_USER + 4)
Private Const TTM_ACTIVATE = WM_USER + 1
Private Const TTM_SETDELAYTIME = (WM_USER + 3)
Private Const TTM_UPDATETIPTEXTA = (WM_USER + 12)
Private Const TTM_SETMAXTIPWIDTH = (WM_USER + 24)
Private Const TTM_SETTIPBKCOLOR = (WM_USER + 19)
Private Const TTM_SETTIPTEXTCOLOR = (WM_USER + 20)
Private Const TTM_SETTITLE = (WM_USER + 32)
Private Const TTS_BALLOON = &H40
Private Const TTS_ALWAYSTIP = &H1
Private Const TTF_SUBCLASS = &H10
Private Const TOOLTIPS_CLASSA = "tooltips_class32"

''Tooltip Window Types
Private Type TOOLINFO
    lSize As Long
    lFlags As Long
    lHwnd As Long
    lId As Long
    lpRect As RECT
    hInstance As Long
    lpStr As String
    lParam As Long
End Type


Private Type CTRL_TIP_TEXT
  m_cHwndTip As Long

  m_lHwndParentObj As Long
  m_cTI As TOOLINFO
  m_sTitle As String
  
  m_cIcon As ttIconType
  m_cForeColor As Long
  m_cBackColor As Long
  m_cCentered As Boolean
  m_cStyle As Long
End Type

Private m_iMaxCtrlTip As Integer
Private m_iIndexTip As Integer
Private m_cTipText() As CTRL_TIP_TEXT

Public Enum ttIconType
    TTNoIcon = 0
    TTIconInfo = 1
    TTIconWarning = 2
    TTIconError = 3
End Enum

Public Sub IniMaxTip(iMaxCtrlTip As Integer)
  'Inicializamos el mximo nmero de TipTextTool
  m_iMaxCtrlTip = iMaxCtrlTip
  ReDim m_cTipText(m_iMaxCtrlTip)
End Sub

Public Sub IniTip()
  Dim i As Integer
  
  'Borramos cualquier ventana.
  For i = 0 To m_iMaxCtrlTip
    With m_cTipText(i)
      If .m_cHwndTip <> 0 Then
        DestroyWindow .m_cHwndTip
      End If
      .m_cHwndTip = 0
    End With
  Next i
  
  'Inicializamos contador de Tip's.
  m_iIndexTip = 0
End Sub

Public Function CreateTip(oParentObj As Object, sText As String, Optional sTitle As String = "") As Boolean
  Dim lpRect As RECT
  
  CreateTip = False
  
  If m_iIndexTip < m_iMaxCtrlTip Then
    With m_cTipText(m_iIndexTip)
      
      'Inicializamos propiedades
      .m_lHwndParentObj = oParentObj.hwnd
      .m_cTI.lpStr = sText
      .m_sTitle = sTitle
      .m_cIcon = TTIconInfo
      .m_cBackColor = RGB(255, 255, 255)      'Blanc
      .m_cForeColor = RGB(0, 0, 150)          'Blau
      .m_cStyle = TTS_ALWAYSTIP Or TTS_NOPREFIX Or TTS_BALLOON
      .m_cCentered = False
    
      If .m_cHwndTip <> 0 Then
        DestroyWindow .m_cHwndTip
      End If
    
      'The parent control has to have been set first
      'If Not mvarParentControl Is Nothing Then
      .m_cHwndTip = CreateWindowEx( _
                    0, _
                    TOOLTIPS_CLASSA, _
                    vbNullString, _
                    .m_cStyle, _
                    CW_USEDEFAULT, _
                    CW_USEDEFAULT, _
                    CW_USEDEFAULT, _
                    CW_USEDEFAULT, _
                    .m_lHwndParentObj, _
                    0, _
                    App.hInstance, _
                    0)
                    
      'Make our tooltip window a topmost window
      SetWindowPos .m_cHwndTip, _
                    HWND_TOPMOST, _
                    0&, _
                    0&, _
                    0&, _
                    0&, _
                    SWP_NOACTIVATE Or SWP_NOSIZE Or SWP_NOMOVE
                    
      'Get the rect of the parent control
      GetClientRect .m_lHwndParentObj, lpRect
        
      'Now set our tooltip info structure
      'if we want it centered, then set that flag
      .m_cTI.lSize = Len(.m_cTI)
      
      If .m_cCentered Then
        .m_cTI.lFlags = TTF_SUBCLASS Or TTF_CENTERTIP
      Else
        .m_cTI.lFlags = TTF_SUBCLASS
      End If
            
      'Set the hwnd prop to our parent control's hwnd
      .m_cTI.lHwnd = .m_lHwndParentObj
      .m_cTI.lId = 0
      .m_cTI.hInstance = App.hInstance
      '.lpstr = ALREADY SET
      .m_cTI.lpRect = lpRect
        
      'Add the tooltip structure
      SendMessage .m_cHwndTip, TTM_ADDTOOLA, 0&, .m_cTI
      SendMessage .m_cHwndTip, TTM_SETDELAYTIME, TTDT_AUTOPOP, ByVal 30000&
      SendMessage .m_cHwndTip, TTM_SETMAXTIPWIDTH, 0, 80
      SendMessage .m_cHwndTip, TTM_SETTIPTEXTCOLOR, .m_cForeColor, 0&
      SendMessage .m_cHwndTip, TTM_SETTIPBKCOLOR, .m_cBackColor, 0&
      
      'If we want a title or we want an icon
      If .m_sTitle <> vbNullString Or .m_cIcon <> TTNoIcon Then
        SendMessage .m_cHwndTip, TTM_SETTITLE, CLng(.m_cIcon), ByVal .m_sTitle
      End If
        
      SendMessage .m_cHwndTip, TTM_UPDATETIPTEXTA, 0&, .m_cTI
        
    End With
    CreateTip = True
    m_iIndexTip = m_iIndexTip + 1
  End If
End Function

Private Sub Class_Terminate()
  Dim i As Integer
  
  For i = 0 To m_iMaxCtrlTip
    With m_cTipText(i)
      If .m_cHwndTip <> 0 Then
        DestroyWindow .m_cHwndTip
      End If
      .m_cHwndTip = 0
    End With
  Next i
End Sub




