Attribute VB_Name = "NSDK"
'//////////////////////////////////////////////////////////////////////////////////////////////
'
'                    LIBRERIA CON FUNCIONES PARA TRABAJO CON SDK DE NITGEN.
'                                                                                   Ver.: 1.0.0
'                                                                              Data: 12/02/2008
' KIMALDI ELECTRONICS, s.l.                                                 Autor: Josep Ricart
'//////////////////////////////////////////////////////////////////////////////////////////////

Option Explicit

'---------------------------------------------------------------------------------
'SDK eNBSP
'---------------------------------------------------------------------------------
Dim objNBioBSP As NBioBSPCOMLib.NBioBSP
Dim objNSearch As INSearch              ' NSearch object
Dim objDevice As IDevice                ' Device object
Dim objExtraction As IExtraction        ' Extraction object
Dim objMatching As IMatching            ' Matching object
Dim objFPData As IFPData                ' FPData object
Dim objFPImage As IFPImage              ' Control de calidad de imagen
'---------------------------------------------------------------------------------

'--------------------------------------------------------------------------------
'Inicializamos los objetos de las SDK.
'--------------------------------------------------------------------------------
Public Function NSDK_Ini() As String
  'Create NBioBSP object
  Set objNBioBSP = New NBioBSPCOMLib.NBioBSP
  Set objNSearch = objNBioBSP.NSearch
  Set objDevice = objNBioBSP.Device
  Set objExtraction = objNBioBSP.Extraction
  Set objMatching = objNBioBSP.Matching
  Set objFPData = objNBioBSP.FPData
  Set objFPImage = objNBioBSP.FPImage
  
  Call objDevice.Enumerate

End Function

'--------------------------------------------------------------------------------
'Finalizamos los objetos de las SDK.
'--------------------------------------------------------------------------------
Public Sub NSDK_Fin()
  Set objDevice = Nothing
  Set objExtraction = Nothing
  Set objMatching = Nothing
  Set objFPData = Nothing
  Set objFPImage = Nothing
  Set objNSearch = Nothing
  Set objNBioBSP = Nothing
End Sub

' Carga en memoria la base de datos de un fichero.
'--------------------------------------------------------------------------------
' Valor de retorno:
'           0 = Operacin realizada correctamente.
'           1 = Error al realizar la operacin.
'--------------------------------------------------------------------------------
Public Function NSDK_LoadDB(szFileName As String) As Byte
  'Inicializamos valor de retorno
  NSDK_LoadDB = 0
  
  'Load SearchDB from File
  Call objNSearch.LoadDBFromFile(szFileName)

  'Detectamos si ha habido error
  If objNSearch.ErrorCode <> NBioAPIERROR_NONE Then
    MsgBox objNSearch.ErrorDescription & " [" & objNSearch.ErrorCode & "]", vbOKOnly, "Error"
    NSDK_LoadDB = 1
  End If
End Function

' Guarda la base de datos de memoria en un fichero
'--------------------------------------------------------------------------------
' Valor de retorno:
'           0 = Operacin realizada correctamente.
'           1 = Error al realizar la operacin.
'--------------------------------------------------------------------------------
Public Function NSDK_SaveDB(szFileName As String) As Byte
  'Inicializamos valor de retorno
  NSDK_SaveDB = 0
  
  'Save SearchDB from File
  Call objNSearch.SaveDBToFile(szFileName)
    
  'Detectamos si ha habido error
  If objNSearch.ErrorCode <> NBioAPIERROR_NONE Then
    MsgBox objNSearch.ErrorDescription & " [" & objNSearch.ErrorCode & "]", vbOKOnly, "Error"
    NSDK_SaveDB = 1
  End If
End Function

' Aade huella a la base de datos
'--------------------------------------------------------------------------------
' Valor de retorno:
'           0 = Operacin realizada correctamente.
'           1 = Error al realizar la operacin.
'--------------------------------------------------------------------------------
Public Function NSDK_AddFIR(sUserFIR As String, iUserID As Integer) As Byte
  Dim lUserID As Long
  Dim sAux As String
  
  'Inicializamos valor de retorno
  NSDK_AddFIR = 0
  
  'Antes de dar de alta el usuario comprovamos que no exista.
  lUserID = CLng(iUserID)
  sAux = NDSK_IdentifyUser(sUserFIR, NBioAPI_FIR_SECURITY_LEVEL_NORMAL)
      
  If sAux = "" Then
    'Aadimos huella
    Call objNSearch.AddFIR(sUserFIR, lUserID)
  
    'Detectamos si ha habido error
    If objNSearch.ErrorCode <> NBioAPIERROR_NONE Then
      MsgBox objNSearch.ErrorDescription & " [" & objNSearch.ErrorCode & "]"
      NSDK_AddFIR = 1
    End If
  Else
    NSDK_AddFIR = 2
    MsgBox "Error: Huella ya registrada!!"
  End If
End Function
      
Public Function NSDK_AddBio(iUserID As Integer, sHuellaBio1 As String, sHuellaBio2 As String) As Byte
  Dim sUserFIR As String
  
  NSDK_AddBio = 1
  If NDSK_BioMaxFP2NSearchFP(sHuellaBio1, sHuellaBio2, sUserFIR) = 0 Then
    NSDK_AddBio = NSDK_AddFIR(sUserFIR, iUserID)
  End If
End Function


' Borra usuario de la base de datos
'--------------------------------------------------------------------------------
' Valor de retorno:
'           0 = Operacin realizada correctamente.
'           1 = Error al realizar la operacin.
'--------------------------------------------------------------------------------
Public Function NSDK_DelUser(iUserID As Integer) As Byte
  On Error Resume Next
  Dim lUserID As Long
  'Inicializamos valor de retorno
  NSDK_DelUser = 0
  
  'Borramos usuario
  lUserID = CLng(iUserID)
  Call objNSearch.RemoveUser(lUserID)
  
  'Detectamos si ha habido error
  If objNSearch.ErrorCode <> NBioAPIERROR_NONE Then
    MsgBox objNSearch.ErrorDescription & " [" & objNSearch.ErrorCode & "]"
    NSDK_DelUser = 1
  End If
End Function
      
' Borra usuario de la base de datos
'--------------------------------------------------------------------------------
' Valor de retorno:
'           0 = Operacin realizada correctamente.
'           1 = Error al realizar la operacin.
'--------------------------------------------------------------------------------
Public Function NSDK_DelAll() As Byte
  'Inicializamos valor de retorno
  NSDK_DelAll = 0
  
  'Borramos base de datos
  Call objNSearch.ClearDB
  
  'Detectamos si ha habido error
  If objNSearch.ErrorCode <> NBioAPIERROR_NONE Then
    MsgBox objNSearch.ErrorDescription & " [" & objNSearch.ErrorCode & "]"
    NSDK_DelAll = 1
  End If
End Function

' Cogemos el numero de huellas de la base de datos.
'--------------------------------------------------------------------------------
' Valor de retorno:
'    Nmero de huellas en la base de datos.
'--------------------------------------------------------------------------------
Public Function NSDK_GetNumDB() As Integer
  NSDK_GetNumDB = objNSearch.GetDataCountFromDB
End Function

Public Function NSDK_GetStatusHamster() As String
  NSDK_GetStatusHamster = objDevice.ErrorDescription & " [" & objDevice.ErrorCode & "]"
End Function

' Borra usuario de la base de datos
'--------------------------------------------------------------------------------
' Valor de retorno:
'           ""   = Usuario no encontrado.
'           "xx" = Identificador de usuario.
'--------------------------------------------------------------------------------
Public Function NDSK_IdentifyUser(sUserFIR, iSecurity) As String
  'Inicializamos valor de retorno
  NDSK_IdentifyUser = ""
  
  If sUserFIR <> "" Then
    'Identificamos usuario
    Call objNSearch.IdentifyUser(sUserFIR, CLng(iSecurity))
  
    'Detectamos si ha habido error
    If objNSearch.ErrorCode <> NBioAPIERROR_NONE Then
'      MsgBox objNSearch.ErrorDescription & " [" & objNSearch.ErrorCode & "]"
    Else
      NDSK_IdentifyUser = objNSearch.UserId
    End If
  End If
End Function
      
' Funcin para convertir huella en formato BioOcx a formato de la DB NSearch
'--------------------------------------------------------------------------------
' Valor de retorno:
'           0 = Operacin realizada correctamente.
'           1 = Error de datos.
'           2 = Error en la llamada Import.
'--------------------------------------------------------------------------------
Function NDSK_BioMaxFP2NSearchFP(sUserFP1 As String, sUserFP2 As String, sUserFIR As String) As Byte
Dim i As Integer
Dim arrB1() As Byte
Dim arrB2() As Byte
Dim auxbiFIR1 As Variant
Dim auxbiFIR2 As Variant

Dim blninitialize As Boolean
Dim nFingerID As Long
Dim nSrcFPDataType As Long
Dim nFPDataSize As Long
'Dim biFIR_B() As Byte  'Definida como global

  'Inicializamos valor de retorno
  NDSK_BioMaxFP2NSearchFP = 0

  'Comprovamos longitud de huella pasada como parametro (capturada con el OCX).
  If sUserFP2 <> "" Then
    If Len(sUserFP1) <> Len(sUserFP2) Then
      NDSK_BioMaxFP2NSearchFP = 1
    End If
  End If
  
  If NDSK_BioMaxFP2NSearchFP = 0 Then
    Select Case Len(sUserFP1)
      Case 800:
        nSrcFPDataType = 5        'Huella de FIM30xx
      Case 808:
        nSrcFPDataType = 7        'Huella de FIM20xx
      Case Else:
'        MsgBox "Error de datos!!"
        NDSK_BioMaxFP2NSearchFP = 1   'Error!!!
    End Select
  End If

  If NDSK_BioMaxFP2NSearchFP = 0 Then
    'Conversin de formato OCX a FDA (textencodedFIR)
    ReDim arrB1(0 To (Len(sUserFP1) / 2) - 1)
    For i = 0 To (Len(sUserFP1) / 2) - 1
      arrB1(i) = CByte(val("&H" + Mid(sUserFP1, i * 2 + 1, 2)))
    Next i
    auxbiFIR1 = arrB1

    ReDim arrB2(0 To (Len(sUserFP1) / 2) - 1)
    For i = 0 To (Len(sUserFP2) / 2) - 1
      arrB2(i) = CByte(val("&H" + Mid(sUserFP2, i * 2 + 1, 2)))
    Next i
    auxbiFIR2 = arrB2

    'Assignaci dels valors dels parmetres
    nFPDataSize = LenB(auxbiFIR1)
    blninitialize = True
    nFingerID = 0
  
    'Llamada a la funcin Import - De FIM a Hamster
    If sUserFP2 <> "" Then
      Call objFPData.Import(blninitialize, nFingerID, 2, nSrcFPDataType, nFPDataSize, auxbiFIR1, auxbiFIR2)
    Else
      Call objFPData.Import(blninitialize, nFingerID, 2, nSrcFPDataType, nFPDataSize, auxbiFIR1)
    End If
    If objFPData.ErrorCode <> NBioAPIERROR_NONE Then
      MsgBox "Import Function Failed ! - " & objFPData.ErrorDescription & " [" & objFPData.ErrorCode & "]"
      NDSK_BioMaxFP2NSearchFP = 2   'Error!!!
    Else
      'Obtencin de las huellas en formato FIR
        'ReDim biFIR_B(objFPData.FIRLength) As Byte
         ' biFIR_B = Space(objFPData.FIRLength)
        'biFIR_B = objFPData.FIR
      'Obtencin de las huellas en formato TextEncodedFIR
      sUserFIR = objFPData.TextEncodeFIR
    End If
  End If
End Function

' Funcin para capturar huellas de usuario para su enrolamiento.
'--------------------------------------------------------------------------------
' Valor de retorno:
'           Informacin de huellas de usuario.
'--------------------------------------------------------------------------------
Public Function NSDK_GetUserFIR() As String
  Dim iAux As Integer
  Dim sAux As String
  
  'Inicializamos variables.
  NSDK_GetUserFIR = ""

  'Get FIR data
  Call objDevice.Open(NBioAPI_DEVICE_ID_AUTO_DETECT)
  Call objExtraction.Enroll(Null)
  Call objDevice.Close(NBioAPI_DEVICE_ID_AUTO_DETECT)
  
  'Si error en la captura -> mostramos mensaje de error y salimos.
  If objExtraction.ErrorCode <> NBioAPIERROR_NONE Then
    MsgBox objExtraction.ErrorDescription & " [" & objExtraction.ErrorCode & "]"
    Exit Function
  End If
  
  NSDK_GetUserFIR = objExtraction.TextEncodeFIR

End Function

Public Function NSDK_GetQuality() As String
  Dim i As Integer
  Dim j As Integer
  Dim lRet As Long
  Dim sAux As String
  
  Call objFPData.CheckQuality(objExtraction.FIR, objFPImage.AuditData)
  
  For i = 0 To objFPData.TotalFingerCount - 1
    For j = 0 To objFPData.SampleNumber - 1
      lRet = objFPData.QualityInfo(objFPData.FingerID(i), j)
      sAux = sAux + CStr(lRet) + "-"
    Next j
  Next i
  
  NSDK_GetQuality = Mid(sAux, 1, Len(sAux) - 1)
End Function

' Funcin para capturar una huella de usuario para su identificacin.
'--------------------------------------------------------------------------------
' Valor de retorno:
'           Informacin de la huella de usuario.
'--------------------------------------------------------------------------------
Public Function NDSK_GetHuella() As String
  'Inicializamos variables.
  NDSK_GetHuella = ""

  'Get FIR data
  Call objDevice.Open(NBioAPI_DEVICE_ID_AUTO_DETECT)
  Call objExtraction.Capture(NBioAPI_FIR_PURPOSE_VERIFY)
  Call objDevice.Close(NBioAPI_DEVICE_ID_AUTO_DETECT)
  
  'Si error en la captura -> mostramos mensaje de error.
  If objExtraction.ErrorCode <> NBioAPIERROR_NONE Then
    MsgBox objExtraction.ErrorDescription & " [" & objExtraction.ErrorCode & "]"
  Else
    NDSK_GetHuella = objExtraction.TextEncodeFIR
  End If
End Function

'--------------------------------------------------------------------------------
' CAPTURA DE HUELLA HAMSTER EN FORMATO HV
'--------------------------------------------------------------------------------
' Valor de retorno:
'               0 = OK
'               1 = Error de captura.
'--------------------------------------------------------------------------------
Public Function NDSK_GetHuellaHV(vMinutiae1 As Variant, vMinutiae2 As Variant) As Byte
  Dim sAux As String
  Dim sFingerID As String

  'Inicializamos variables
  NDSK_GetHuellaHV = 0
  
  'Capturamos huella.
  objDevice.Open NBioAPI_DEVICE_ID_AUTO_DETECT          'Open device
  Call objExtraction.Enroll(Null)                       'Enroll
  objDevice.Close NBioAPI_DEVICE_ID_AUTO_DETECT         'Close Device
  
  If objExtraction.ErrorCode = NBioAPIERROR_NONE Then
    sAux = objExtraction.TextEncodeFIR
    'Export
    Call objFPData.Export(sAux, MINCONV_TYPE_FIM01_HV)   'Export Hamster a HV TYPE
    If objFPData.TotalFingerCount > 0 Then
      sFingerID = objFPData.FingerID(0)
      vMinutiae1 = objFPData.FPData(sFingerID, 0) 'Info Template 1
      vMinutiae2 = objFPData.FPData(sFingerID, 1) 'Info Template 2
    End If
  Else
    NDSK_GetHuellaHV = 1
  End If
End Function



