Attribute VB_Name = "KimLib01"
'//////////////////////////////////////////////////////////////////////////////////////////////
'
'                       LIBRERIA CON FUNCIONES UTILES PARA APLICACIONES
'                                                                                   Ver.: 1.0.0
'                                                                              Data: 11/01/2008
' KIMALDI ELECTRONICS, s.l.                                                 Autor: Josep Ricart
'//////////////////////////////////////////////////////////////////////////////////////////////

Option Explicit

'----------------------------------------------------------------------------------------------
'RUTINA QUE DEVUELVE LA FECHA I HORA ACTUAL, EN FORMATO CADENA PARA FUNCIN "SetTime" del FIM.
'----------------------------------------------------------------------------------------------
Public Function GetTimeInfo2FIM() As String
  Dim iPos As Integer
  Dim sAuxDate As String
  Dim sAuxTime As String
  Dim sVal As String
  Dim vAux As Variant
  
  GetTimeInfo2FIM = ""
  
  'Cogemos la fecha del sistema.
  vAux = Now
   
  'Cogemos el ao.
  GetTimeInfo2FIM = GetTimeInfo2FIM + Right("0000" + LTrim(Str(Year(vAux))), 4)
  
  'Cogemos el mes.
  GetTimeInfo2FIM = GetTimeInfo2FIM + Right("00" + LTrim(Str(Month(vAux))), 2)
  
  'Cogemos el dia.
  GetTimeInfo2FIM = GetTimeInfo2FIM + Right("00" + LTrim(Str(Day(vAux))), 2)
  
  'Cogemos la hora.
  GetTimeInfo2FIM = GetTimeInfo2FIM + Right("00" + LTrim(Str(Hour(vAux))), 2)
  
  'Cogemos los minutos.
  GetTimeInfo2FIM = GetTimeInfo2FIM + Right("00" + LTrim(Str(Minute(vAux))), 2)
  
  'Cogemos los segundos.
  GetTimeInfo2FIM = GetTimeInfo2FIM + Right("00" + LTrim(Str(Second(vAux))), 2)
  
  'Aadimos "00" (fijo)
  GetTimeInfo2FIM = GetTimeInfo2FIM + "00"
End Function

'----------------------------------------------------------------------------------------------
' Rutina que convierte un valor byte en una cadena de dos caracteres, que expresan el valor en hexa.
'----------------------------------------------------------------------------------------------
Public Function Byte2StrHex(b As Byte) As String
  Dim s As String
  s = Hex(b)
  Do While Len(s) < 2
    s = "0" + s
  Loop
  Byte2StrHex = s
End Function

Public Function StrByte2StrHex(sStrByte As String) As String
  Dim i As Integer
  Dim sRet As String
  
  'Inicialitzamos.
  sRet = ""
  
  'Bucle para convertir todos los carcteres.
  For i = 1 To Len(sStrByte)
    sRet = sRet + Byte2StrHex(Asc(Mid(sStrByte, i, 1)))
  Next i
  
  'Inicializamos valor de retorno.
  StrByte2StrHex = sRet
End Function

Public Function StrHex2Byte(sStrHex As String) As Byte
  StrHex2Byte = val("&H" + Mid(sStrHex, 1, 2))
End Function

Public Function StrHex2StrByte(sStrHex As String) As String
  Dim b As Byte
  Dim i As Integer
  Dim sRet As String
  
  'Inicialitzamos.
  sRet = ""
  
  'Bucle para convertir todos los carcteres.
  For i = 1 To Len(sStrHex) Step 2
    sRet = sRet + Chr(StrHex2Byte(Mid(sStrHex, i, 2)))
  Next i
  
  'Inicializamos valor de retorno.
  StrHex2StrByte = sRet
End Function

'----------------------------------------------------------------------------------
' Formateja una cadena a 20 carcters.
'----------------------------------------------------------------------------------
Function StringLen20(StrString As String) As String
  While Len(StrString) < &H14
    StrString = StrString + " "
  Wend
  StringLen20 = Left(StrString, 20)
End Function

Public Function Byte2Hex(bVal As Byte) As String
  Byte2Hex = Right("00" + Hex(bVal), 2)
End Function




